<?php
/**
* Plugin Name: WooCommerce Page Builder For Elementor
* Plugin URI: https://1.envato.market/NJNQK
* Description: is the ideal Elementor add-on to effortlessly layout for WooCommerce and more.
* Version: 1.1.6.7
* Author: DawnThemes 
* Author URI: https://codecanyon.net/user/dawnthemes
* Copyright @2019 by DawnThemes
* License: License GNU General Public License version 2 or later
* Text-domain: woocommerce-builder-elementor
* WC tested up to: 8.3.0
* Elementor tested up to: 3.17.3
* 
* @package WooCommerce-Builder-Elementor
*/

// don't load directly
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// Define
define( 'DTWCBE_VERSION', '1.1.6.7' );

define( 'DTWCBE__FILE__', __FILE__ );
define( 'DTWCBE_PLUGIN_FILE', wp_normalize_path( DTWCBE__FILE__ ) );
define( 'DTWCBE_PLUGIN_BASENAME', plugin_basename( DTWCBE__FILE__ ) );
define( 'DTWCBE_PATH', plugin_dir_path( DTWCBE__FILE__ ) );
define( 'DTWCBE_PATH_URL' , plugin_dir_url( DTWCBE__FILE__ ));
define( 'DTWCBE_URL', plugins_url( '/', DTWCBE__FILE__ ) );

define( 'DTWCBE_MODULES_PATH', plugin_dir_path( DTWCBE__FILE__ ) . 'modules' );
define( 'DTWCBE_ASSETS_PATH', DTWCBE_URL . 'assets/' );
define( 'DTWCBE_ASSETS_URL', DTWCBE_URL . 'assets/' );


// Include the main DTWCBE_WooCommerce_Builder_Elementor class.
if( !class_exists('DTWCBE_WooCommerce_Builder_Elementor') ){
	include_once dirname( __FILE__ ) . '/includes/class-woocommerce-builder-elementor.php';
}

/**
 * Main instance of DTWCBE_WooCommerce_Builder_Elementor.
 *
 * Returns the main instance of DTWCBE to prevent the need to use globals.
 *
 * @since  1.0
 * @return DTWCBE_WooCommerce_Builder_Elementor
 */
function DTWCBE_WooCommerce_Builder_Elementor() {
	return DTWCBE_WooCommerce_Builder_Elementor::instance();
}

// Global for backwards compatibility.
$GLOBALS['dtwcbe'] = DTWCBE_WooCommerce_Builder_Elementor();
